clear;
rng(12345);

n = 2;
m = 2;

%% Define Nonconvex Functions
f = @(x) (x(1)+pi/20)^2 + (x(2)+1)^2;
grad_f = @(x) [2*(x(1)+pi/20); 2*(x(2)+1)];
g = @(x) (x(2)-sin(10*x(1)))^2;
grad_g = @(x) [-2*cos(10*x(1))*(x(2)-sin(10*x(1))); 2*(x(2)-sin(10*x(1)))];

%% Parameters
accuracy = 1e-4;
param.epsilong = accuracy;
param.epsilonf = accuracy;
param.max_iter = 1e3;
param.stepsize = 1e-2;

%% Initialization
x0 = [-3; -1];

%% DBGD
param.beta = 1;
[x_dbgd, f_vec_dbgd, g_vec_dbgd, f_par_dbgd, f_orth_dbgd, angle_dbgd, lam_vec_dbgd, x_hist_dbgd] = ...
    DBGD_new(f, grad_f, g, grad_g, param, x0);

%% Penalty GD for multiple lambdas
lambda_list = [1, 10, 100, 1000];
colors = {'m', 'k', 'c', 'r', 'y'};
for i = 1:length(lambda_list)
    lambda_penalty = lambda_list(i);
    [x_pen{i}, f_pen{i}, g_pen{i}, f_par_pen{i}, f_orth_pen{i}, angle_pen{i}, x_hist_pen{i}] = ...
        PenaltyGD_new(f, grad_f, g, grad_g, param, x0, lambda_penalty);
end

%% Plot: ||grad g||^2
figure; hold on; grid on;
semilogy(g_vec_dbgd, 'b-', 'LineWidth', 2.5);
for i = 1:length(lambda_list)
    semilogy(g_pen{i}, [colors{i} '--'], 'LineWidth', 2.5);
end
xlabel('\textbf{Number of Iterations}', 'Interpreter', 'latex', 'FontSize', 20); 
ylabel('$\|\nabla g\|^2$', 'Interpreter', 'latex', 'FontSize', 20); 
legend(['DBGD', arrayfun(@(l) sprintf('Penalty $\\lambda=%.0f$', l), lambda_list, 'UniformOutput', false)], ...
    'Location', 'southwest', 'Interpreter', 'latex', 'FontSize', 18);
set(gca, 'YScale', 'log', 'FontSize', 18);
% title('$\|\nabla g\|^2$ vs Iteration', 'Interpreter', 'latex', 'FontSize', 20);
hold off;

%% Plot: ||grad_perp f||^2
figure; hold on; grid on;
semilogy(f_orth_dbgd, 'b-', 'LineWidth', 2.5);
for i = 1:length(lambda_list)
    semilogy(f_orth_pen{i}, [colors{i} '--'], 'LineWidth', 2.5);
end
xlabel('\textbf{Number of Iterations}', 'Interpreter', 'latex', 'FontSize', 20); 
ylabel('$\|\nabla_{\perp} f\|^2$', 'Interpreter', 'latex', 'FontSize', 20); 
legend(['DBGD', arrayfun(@(l) sprintf('Penalty $\\lambda=%.0f$', l), lambda_list, 'UniformOutput', false)], ...
    'Location', 'southwest', 'Interpreter', 'latex', 'FontSize', 18);
set(gca, 'YScale', 'log', 'FontSize', 18);
% title('$\|\nabla_{\perp} f\|^2$ vs Iteration', 'Interpreter', 'latex', 'FontSize', 20);
hold off;

% %% Plot: ||grad_parallel f||^2
% figure; hold on; grid on;
% 
% % DBGD result
% semilogy(f_par_dbgd, 'b-', 'LineWidth', 2.5);
% 
% % Penalty method results
% for i = 1:length(lambda_list)
%     semilogy(f_par_pen{i}, [colors{i} '--'], 'LineWidth', 2.5);
% end
% 
% xlabel('\textbf{Number of Iterations}', 'Interpreter', 'latex', 'FontSize', 20); 
% ylabel('$\|\nabla_{\parallel} f\|^2$', 'Interpreter', 'latex', 'FontSize', 20); 
% 
% legend(['DBGD', arrayfun(@(l) sprintf('Penalty $\\lambda=%.0f$', l), lambda_list, 'UniformOutput', false)], ...
%     'Location', 'southwest', 'Interpreter', 'latex', 'FontSize', 18);
% 
% set(gca, 'YScale', 'log', 'FontSize', 18);
% % title('$\|\nabla_{\parallel} f\|^2$ vs Iteration', 'Interpreter', 'latex', 'FontSize', 20);
% hold off;


%% Plot: cosine angle
figure; hold on; grid on;
plot(angle_dbgd, 'b-', 'LineWidth', 2.5);
for i = 1:length(lambda_list)
    plot(angle_pen{i}, [colors{i} '--'], 'LineWidth', 2.5);
end
xlabel('\textbf{Number of Iterations}', 'Interpreter', 'latex', 'FontSize', 20); 
ylabel('$\cos \theta$', 'Interpreter', 'latex', 'FontSize', 20); 
legend(['DBGD', arrayfun(@(l) sprintf('Penalty $\\lambda=%.0f$', l), lambda_list, 'UniformOutput', false)], ...
    'Location', 'southwest', 'Interpreter', 'latex', 'FontSize', 18);
ylim([-1, 1]);
set(gca, 'FontSize', 18);
% title('$\cos(\theta)$ between $\nabla f$ and $\nabla g$', 'Interpreter', 'latex', 'FontSize', 20);
hold off;


